select A.CVEN, A.VENDEDOR, A.CPRO, A.PROVEEDOR, SUBTOTAL, B.META
from
  (
  select C.id_vendedor as CVEN, V.nombre as VENDEDOR,
  A.id_proveedor as CPRO, P.nombre as PROVEEDOR,
  SUM(D.subtotal) as SUBTOTAL,
  SUM(D.igv) as IGV,
  SUM(D.total) as TOTAL
  from _sv_venta_detalle D
  inner join _sv_venta C ON D.id_venta = C.id_venta
  inner join _sv_producto A ON D.id_producto = A.id_producto
  inner join _sv_proveedor P ON A.id_proveedor = P.id_proveedor
  inner join _sv_vendedor V ON C.id_vendedor = V.id_vendedor
  where C._estado = 'A'
  and D._estado = 'A'
  and C.estado <> 'AN'
  and C.id_motivo_rechazo = 0
  and C.fecha_emision >= '2011-08-01'
  and C.fecha_emision <= '2011-08-20'
  GROUP BY C.id_vendedor, V.nombre,
  A.id_proveedor, P.nombre
  ) A
left join
  (
  select M.id_vendedor as CVEN, M.id_proveedor as CPRO, M.monto as META
  from _sv_metas M
  where M.id_anio = '2011'
  and M.id_mes = '08'
  and M.id_proveedor = 
  ) B 
on A.CVEN = B.CVEN and A.CPRO = B.CPRO;



select A.CVEN, A.VENDEDOR,  VENTA, B.META, ROUND(VENTA/META*100,2) AS AVANCE,
VENTA/spFuncion_DiasAcumulados('2011','08')*spFuncion_DiasUtiles('2011','08') as TENDENCIA,
(VENTA/spFuncion_DiasAcumulados('2011','08')*spFuncion_DiasUtiles('2011','08'))/META*100 AS PORC_TENDENCIA,

spFuncion_DiasUtiles('2011','08') AS UTIL,
spFuncion_DiasAcumulados('2011','08') AS ACUM
from
  (
  select C.id_vendedor as CVEN,